<?php

if( !function_exists( 'sm_highlight_func' ) ) {
	function sm_highlight_func( $atts, $content = null ) {
		extract ( shortcode_atts ( array (
			'color' => '',
			'v_padding' => '',
			'h_padding' => '',
			'margin_left' => '',
			'margin_right' => '',
			'style' => '',
		), $atts ) );
		$inline_css = '';
		$def_border_radius = 2;
		$h_radius = 4;
		$v_radius = 2;
		if ( !empty( $color ) ){
			$inline_css .= 'background-color:' . $color . ';';
		}
		if ( $v_padding != '' ) {
			$v_padding = sm_validate_length_unit( $v_padding );
			$inline_css .= 'padding-top:' . $v_padding .';';
			$inline_css .= 'padding-bottom:' . $v_padding .';';
			$inline_css .= 'line-height: 1;';
			$v_radius = max( $v_radius, intval( $v_padding ) / 2 );
		}
		if ( $h_padding != '' ) {
			$h_padding = sm_validate_length_unit( $h_padding );
			$inline_css .= 'padding-left:' . $h_padding .';';
			$inline_css .= 'padding-right:' . $h_padding .';';
			$h_radius = max( $h_radius, intval( $h_padding ) / 2 );
		}
		if ( $margin_left != '' ) {
			$margin_left = sm_validate_length_unit( $margin_left );
			$inline_css .= 'margin-left:' . $margin_left .';';
		}
		if ( $margin_right != '' ) {
			$margin_right = sm_validate_length_unit( $margin_right );
			$inline_css .= 'margin-right:' . $margin_right .';';
		}

		$new_radius = min( $h_radius, $v_radius );
		if ( $new_radius > $def_border_radius ) {
			$inline_css .= 'border-radius:' . $new_radius . 'px;';
		}
		$style = sm_validate_with_array( $style, sm_get_highlight_styles() );
		if ( 'gradient' == $style ) {
			$inline_css .= sm_get_bg_img_gradient_css( 'rgba(0, 0, 0, 0)', 'rgba(0, 0, 0, 0.25)', 0 );
		}
		if ( $inline_css != '' ) $inline_css = ' style="' . $inline_css . '"';

		$output = '';
		$output .= '<span class="sm-highlight"' . $inline_css . '>';
		$output .= do_shortcode( $content );
		$output .= '</span>';
		return $output;
	}
}

sm_register_shortcode( array (
	'name' => esc_html__( 'Highlight Text', 'semona-extension' ),
	'base' => 'sm_highlight',
	//'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-highlight.png',
	'params' => array(
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Text', 'semona-extension' ),
			'param_name' => 'content',
			'value' => '',
			'description' => esc_html__( 'Specify text content.', 'semona-extension' ),
		),
		array(
			'type' => 'colorpicker',
			'heading' => esc_html__( 'Highlight Color', 'semona-extension' ),
			'param_name' => 'color',
			'description' => esc_html__( 'Specify highlight background color.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'dropdown',
			'heading' => esc_html__( 'Style', 'semona-extension' ),
			'param_name' => 'style',
			'value' => sm_get_highlight_styles(),
			'description' => esc_html__( 'Specify highlight fill style.', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Horizontal Padding', 'semona-extension' ),
			'param_name' => 'h_padding',
			'description' => esc_html__( 'Leave blank to use default. (Note: CSS measurement units allowed.)', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Vertical Padding', 'semona-extension' ),
			'param_name' => 'v_padding',
			'description' => esc_html__( 'Leave blank to use default. (Note: CSS measurement units allowed.)', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Left Margin', 'semona-extension' ),
			'param_name' => 'margin_left',
			'description' => esc_html__( 'Leave blank to use default. (Note: CSS measurement units allowed.)', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
		array(
			'type' => 'textfield',
			'heading' => esc_html__( 'Right Margin', 'semona-extension' ),
			'param_name' => 'margin_right',
			'description' => esc_html__( 'Leave blank to use default. (Note: CSS measurement units allowed.)', 'semona-extension' ),
			'edit_field_class' => 'vc_col-sm-6 vc_column',
		),
	)
) );